/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.model;

import com.badlogic.gdx.math.Vector2;

public enum EntityAssetOrientation {
    DOWN(null, new Vector2(0.0f, -1.0f)),
    UP(DOWN, new Vector2(0.0f, 1.0f)),
    LEFT(DOWN, new Vector2(-1.0f, 0.0f)),
    RIGHT(DOWN, new Vector2(1.0f, 0.0f)),
    DOWN_LEFT(LEFT, new Vector2(-1.0f, -1.0f).nor()),
    DOWN_RIGHT(RIGHT, new Vector2(1.0f, -1.0f).nor()),
    UP_LEFT(LEFT, new Vector2(-1.0f, 1.0f).nor()),
    UP_RIGHT(RIGHT, new Vector2(1.0f, 1.0f).nor());

    private EntityAssetOrientation fallback;
    private Vector2 asVector;

    private EntityAssetOrientation(EntityAssetOrientation fallback, Vector2 vector) {
        this.fallback = fallback;
        this.asVector = vector;
    }

    public boolean hasFallback() {
        return this.fallback != null;
    }

    public static EntityAssetOrientation fromFacing(Vector2 facing) {
        if (facing.x > 0.0f) {
            if (facing.y > 0.866f) {
                return UP;
            }
            if (facing.y > 0.1f) {
                return UP_RIGHT;
            }
            if (facing.y > -0.866f) {
                return DOWN_RIGHT;
            }
            return DOWN;
        }
        if (facing.y > 0.866f) {
            return UP;
        }
        if (facing.y > 0.1f) {
            return UP_LEFT;
        }
        if (facing.y > -0.866f) {
            return DOWN_LEFT;
        }
        return DOWN;
    }

    public Vector2 toVector2() {
        return this.asVector;
    }
}

